function showPopup(message) {
    const popupContainer = document.getElementById('popupContainer');
    const popupMessage = document.getElementById('popupMessage');
    popupMessage.textContent = message;
    popupContainer.classList.remove('hidden');
}

function closePopup() {
    document.getElementById('popupContainer').classList.add('hidden');
}

// Attach the event handler for form submission
document.addEventListener('DOMContentLoaded', () => {
    const form = document.getElementById('registrationForm');
    form.addEventListener('submit', (e) => {
        e.preventDefault();

        const formData = new FormData(form);
        const name = formData.get('Name');
        const email = formData.get('Email');
        const phone = formData.get('Phone');
        const message = formData.get('Message');

        const data = { name, email, phone, message };

        // fetch('http://localhost:9000/saveregister', {
            fetch('https://wizard-website-4195ffc17a76.herokuapp.com/saveregister', {
            
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(data)
        })
        .then(response => response.json())
        .then(response => {
            const { message } = response;
            if (message === "ThankYou for Contacting!") {
                showPopup("Thank you for contacting us! We will get back to you shortly.");
            }
            form.reset();
        })
        .catch(error => {
            console.error('Error:', error);
            showPopup('An error occurred. Please try again later.');
        });
    });
});








